-- MacroScript File
-- Created:       
-- Last Modified: 
-- Mesh validator
-- Version: 3ds Max 2012
-- Author: Attila Szabo
-- Modified: 
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Nov 30 2012 - first version

NOTE TO LOCALIZATION
Only the headers should be localized

*/

macroScript mesh_validator_toggle 
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_TOOGLE_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_TOOGLE_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniEnabledName = "Enable"
	
	function getMeshValidatorActive =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return meshInspector.Enable 
	)
	
	function setMeshValidatorActive enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "1"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "0"
		)
		meshInspector.Enable = enabled
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getMeshValidatorActive()
	)
	
	On execute Do
	(
		if (getMeshValidatorActive()) then 
			setMeshValidatorActive(false)
		else
			setMeshValidatorActive(true)
	)

)

macroScript mesh_validator_auto_repair
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_AUTOREPAIR_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_AUTOREPAIR_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniRepairName = "Repair"
	local iniShowDialogName = "ShowDialog"
	
	function getAutoRepairEnabled =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return (meshInspector.RepairMesh and (not meshInspector.ShowDialog))
	)
	
	function setAutoRepairEnabled enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "0"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "1"
		)
		meshInspector.ShowDialog = (not enabled)
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getAutoRepairEnabled()
	)
	
	On execute Do
	(
		if (getAutoRepairEnabled()) then 
			setAutoRepairEnabled(false)
		else
			setAutoRepairEnabled(true)
	)

)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBeCv7QTjADqNoJNlXIgmBf3qGTBencesV7
-- qWEArlM8bW0jLFVNr43HrwQjo21db7Yu1nbuKEcEW5EQm/3cx/zTNYNQdTpUF9lL
-- dOB7DhfOHcoqcE2hcVOFTRUyOgiDzO5uF2wFK5FgkYxmPEtIRAQR6RwuQQjU+Kzq
-- mgofnDydXHx/Kh9VQZeBx71F0MM2+qhL7McXyHbTtnhoyHETM5JPLpJWQCJzdBpw
-- pAggtq7WAsmziXkanXZEMAEpPp7bb7+GUmydAMkpC3f1ekMVrEi5SIIeMWHIDm7f
-- yu3/5Ge0HDc1t/iAktjUbHQba9WNcJ6r/Uz+358aeIUErwNPNFA1
-- -----END-SIGNATURE-----